//----------------------------------------------------
// Developed By: MakingSense_otw
//----------------------------------------------------
// Description:
// Rolls one or more dice and displays the animation
// using the Adafruit_SSD1306 library.
//
// Date: Feb 18th 2024
// Version: 1.0
//----------------------------------------------------

#ifndef _DICE_H    
#define _DICE_H    

#include <Adafruit_SSD1306.h>

#define X_LARGE_DICE 44     //Size in pixels for the X-Large Dice
#define LARGE_DICE 40       //Size in pixels for the Large Dice
#define MEDIUM_DICE 29      //Size in pixels for the Medium Dice
#define SMALL_DICE 24       //Size in pixels for the Small Dice

class Dice {

public:

  Dice(void);

  bool begin (Adafruit_SSD1306 *display, bool solid);

  void setNumber (int numberOfDice);
  void setDiceType (int diceType);

  void roll();

private:
  int _numberOfDice = 1;                // The number of dice to roll
  int _minDiceValue = 1;                // Sets the smallest random number. 
  int _maxDiceValue = 6;                // Sets the highest random number. 
  bool _solid = true;                   // If true the dice has a solid white color with black dots
  int _numberOfRollsBeforeStopping = 10;// The number of random dice rolls before stopping

  int _yPositionDice = 20;              // Sets the top location in pixels for the dice images

  Adafruit_SSD1306 *_display;           // Reference to the Adafruit display object

  bool randomized = false;              // A flag to indicate if the random seed value has been set
  int getValue();
  void drawTextNumber (int x, int y, int size, int value, bool solid);
  void drawDiceImage (int x, int y, int size, int value, bool solid);
  void drawDiceShape (int x, int y, int size, int radius, bool solid);
  void drawDiceDots (int x, int y, int radius, bool solid );
  void clearGraphics (void);
};

#endif 