#include <Arduino.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include "dice.h"

#define SCREEN_WIDTH 128    // OLED display width, in pixels
#define SCREEN_HEIGHT 64    // OLED display height, in pixels
#define OLED_RESET     -1   // Reset pin # (or -1 if sharing Arduino reset pin)
#define SCREEN_ADDRESS 0x3C // I2C address of the SSD1306

Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET, 1000000, 1000000);

Dice myDice = Dice();                                                       // Initialize my dice object

const int PIN_SWITCH = 8;                                                   // The number of the pushbutton pin

void setup() {
  
  pinMode(PIN_SWITCH, INPUT);                                               // Initialize the switch pin as an input:

  if(!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS, OLED_RESET)) {    // Initialize the SSD1306 display
    Serial.println(F("SSD1306 allocation failed"));
  }

  display.clearDisplay();                                                   // Clear the display memory
  display.display();                                                        // Display the memory values on the screen

  myDice.begin(&display, true);                                             // 1 : Pass in the reference to the display 
                                                                            // 2 : Display dice as solid color or as an outline
                                                                            // 3 : Enable sound
  myDice.setNumber(4);                                                      // Sets the number of dice to roll
  myDice.setDiceType(6);                                                    // Sets the dice type D4 or D6
}

void loop() {
  if (digitalRead(PIN_SWITCH) == true){
    myDice.roll();
  }
}


