#include "morsecode.h"

MorseCode::MorseCode(){
  //Initialize timing
  calculateTiming();
}

void MorseCode::setSpeed(int speed){
  _unitTime = speed;
  calculateTiming();
}

void MorseCode::setTone(int tone){
  _tone = tone;
}

bool MorseCode::begin(int led, int speaker){
  _ledPin = led;
  _speakerPin = speaker;

  return true;
}

void MorseCode::processNumbers (char number)
{
    switch (number)
    {
        case '0':
          sendMorseChar(_morse_0, sizeof(_morse_0));
          break;

        case '1':
          sendMorseChar(_morse_1, sizeof(_morse_1));
          break;

        case '2':
          sendMorseChar(_morse_2, sizeof(_morse_2));
          break;

        case '3':
          sendMorseChar(_morse_3, sizeof(_morse_3));
          break;

        case '4':
          sendMorseChar(_morse_4, sizeof(_morse_4));
          break;

        case '5':
          sendMorseChar(_morse_5, sizeof(_morse_5));
          break;

        case '6':
          sendMorseChar(_morse_6, sizeof(_morse_6));
          break;

        case '7':
          sendMorseChar(_morse_7, sizeof(_morse_7));
          break;

        case '8':
          sendMorseChar(_morse_8, sizeof(_morse_8));
          break;

        case '9':
          sendMorseChar(_morse_9, sizeof(_morse_9));
          break;
    }
}

void MorseCode::processPunctuation (char punctuation)
{
    switch (punctuation)
    {
        case '.':
          sendMorseChar(_morse_DOT, sizeof(_morse_DOT));
          break;

        case ',':
          sendMorseChar(_morse_COMMA, sizeof(_morse_COMMA));
          break;

        case '?':
          sendMorseChar(_morse_QUESTION, sizeof(_morse_QUESTION));
          break;
    }

}

void MorseCode::processLetters (char letter)
{
    switch (letter)
    {
        case 'A':
          sendMorseChar(_morse_A, sizeof(_morse_A));
          break;

        case 'B':
          sendMorseChar(_morse_B, sizeof(_morse_B));
          break;

        case 'C':
          sendMorseChar(_morse_C, sizeof(_morse_C));
          break;

        case 'D':
          sendMorseChar(_morse_D, sizeof(_morse_D));
          break;

        case 'E':
          sendMorseChar(_morse_E, sizeof(_morse_E));
          break;

        case 'F':
          sendMorseChar(_morse_F, sizeof(_morse_F));
          break;

        case 'G':
          sendMorseChar(_morse_G, sizeof(_morse_G));
          break;

        case 'H':
          sendMorseChar(_morse_H, sizeof(_morse_H));
          break;

        case 'I':
          sendMorseChar(_morse_I, sizeof(_morse_I));
          break;

        case 'J':
          sendMorseChar(_morse_J, sizeof(_morse_J));
          break;

        case 'K':
          sendMorseChar(_morse_K, sizeof(_morse_K));
          break;

        case 'L':
          sendMorseChar(_morse_L, sizeof(_morse_L));
          break;

        case 'M':
          sendMorseChar(_morse_M, sizeof(_morse_M));
          break;

        case 'N':
          sendMorseChar(_morse_N, sizeof(_morse_N));
          break;

        case 'O':
          sendMorseChar(_morse_O, sizeof(_morse_O));
          break;

        case 'P':
          sendMorseChar(_morse_P, sizeof(_morse_P));
          break;

        case 'Q':
          sendMorseChar(_morse_Q, sizeof(_morse_Q));
          break;

        case 'R':
          sendMorseChar(_morse_R, sizeof(_morse_R));
          break;

        case 'S':
          sendMorseChar(_morse_S, sizeof(_morse_S));
          break;

        case 'T':
          sendMorseChar(_morse_T, sizeof(_morse_T));
          break;

        case 'U':
          sendMorseChar(_morse_U, sizeof(_morse_U));
          break;

        case 'V':
          sendMorseChar(_morse_V, sizeof(_morse_V));
          break;

        case 'W':
          sendMorseChar(_morse_W, sizeof(_morse_W));
          break;

        case 'X':
          sendMorseChar(_morse_X, sizeof(_morse_X));
          break;

        case 'Y':
          sendMorseChar(_morse_Y, sizeof(_morse_Y));
          break;

        case 'Z':
          sendMorseChar(_morse_Z, sizeof(_morse_Z));
          break;
    }

}

void MorseCode::send(char message[])
{

  int length = strlen(message);
  Serial.println("Secret message");
  
  for (byte i = 0; i < length; i++) 
  {
    
    if (message[i] == ' ')
    {
      Serial.println();
      delay (_wordBreak);
    }
    else
    {
      if (message[i] >= 'a' && message[i] <= 'z')
      {
        processLetters(message[i] - 32);
      }
      else if (message[i] >= 'A' && message[i] <= 'Z')
      {
        processLetters(message[i]);
      }
      else if (message[i] >= 48 && message[i] <= 57)
      {
        processNumbers(message[i]);
      }
      else if (message[i] == ',' ||message[i] == '.'||message[i] == '?')
      {
        processPunctuation(message[i]);  
      }
      else
      {
        Serial.println("ERROR: Unknown Letter....");
      }

      Serial.print(" , ");
    }
  }
  Serial.println();
}

void MorseCode::sendMorseChar(boolean morseValue[], int size)
{
  for (int x = 0; x<size; x++)
  {
    if (morseValue[x] == 0)
    {
      Serial.print(".");
      dit();
    }
    else
    {
      Serial.print("-");
      da();
    }
  }  
}

  void MorseCode::dit ()
  {

    if (_ledPin != -1){
      digitalWrite(_ledPin, HIGH);
    }
    
    if (_speakerPin != -1){
      tone(_speakerPin, _tone, _dit);
    }

    delay (_dit);
    
    if (_ledPin != -1){
      digitalWrite(_ledPin, LOW);
    }

    delay (_letterBreak);
  }

  void MorseCode::da()
  {
    if (_ledPin != -1){
      digitalWrite(_ledPin, HIGH);
    }
    
    if (_speakerPin != -1){
      tone(_speakerPin, _tone, _da);
    }

    delay (_da);
    
    if (_ledPin != -1){
      digitalWrite(_ledPin, LOW);
    }
    
    delay (_letterBreak);
  }

  void MorseCode::calculateTiming (){
    _dit = _unitTime; 
    _da = 3 * _unitTime;
    _letterBreak = 3 * _unitTime;
    _wordBreak = 7 * _unitTime;
  }



