#ifndef _MORSE_CODE_H    
#define _MORSE_CODE_H    

#include <Arduino.h>

class MorseCode {

public:

  MorseCode(void);

  bool begin (int led, int speaker);

  void send(char message[]);

  void setSpeed (int speed);

  void setTone (int tone);

private:
  void processNumbers (char number);
  void processPunctuation (char punctuation);
  void processLetters (char letter);
  void sendMorseChar(boolean morseValue[], int size);
  void dit(void);
  void da(void);
  void calculateTiming(void);

  const int NOTE_A4 = 440;
  const int NOTE_B4 = 494;
  const int NOTE_C5 = 523;
  const int NOTE_D5 = 587;
  const int NOTE_E5 = 659;
  const int NOTE_F5 = 698;
  const int NOTE_G5 = 784;

  //Morse code definitions
  const boolean _morse_A[2] = {0,1};
  const boolean _morse_B[4] = {1,0,0,0};
  const boolean _morse_C[4] = {1,0,1,0};
  const boolean _morse_D[3] = {1,0,0};
  const boolean _morse_E[1] = {0};
  const boolean _morse_F[4] = {0,0,1,0};
  const boolean _morse_G[3] = {1,1,0};
  const boolean _morse_H[4] = {0,0,0,0};
  const boolean _morse_I[2] = {0,0};
  const boolean _morse_J[4] = {0,1,1,1};
  const boolean _morse_K[3] = {1,0,1};
  const boolean _morse_L[4] = {0,1,0,0};
  const boolean _morse_M[2] = {1,1};
  const boolean _morse_N[2] = {1,0};
  const boolean _morse_O[3] = {1,1,1};
  const boolean _morse_P[4] = {0,1,1,0};
  const boolean _morse_Q[4] = {1,1,0,1};
  const boolean _morse_R[3] = {0,1,0};
  const boolean _morse_S[3] = {0,0,0};
  const boolean _morse_T[1] = {1};
  const boolean _morse_U[3] = {0,0,1};
  const boolean _morse_V[4] = {0,0,0,1};
  const boolean _morse_W[3] = {0,1,1};
  const boolean _morse_X[4] = {1,0,0,1};
  const boolean _morse_Y[4] = {1,0,1,1};
  const boolean _morse_Z[4] = {1,1,0,0};
  
  const boolean _morse_1[5] = {0,1,1,1,1};
  const boolean _morse_2[5] = {0,0,1,1,1};
  const boolean _morse_3[5] = {0,0,0,1,1};
  const boolean _morse_4[5] = {0,0,0,0,1};
  const boolean _morse_5[5] = {0,0,0,0,0};
  const boolean _morse_6[5] = {1,0,0,0,0};
  const boolean _morse_7[5] = {1,1,0,0,0};
  const boolean _morse_8[5] = {1,1,1,0,0};
  const boolean _morse_9[5] = {1,1,1,1,0};
  const boolean _morse_0[5] = {1,1,1,1,1};

  const boolean _morse_DOT[6] = {0,1,0,1,0,1};
  const boolean _morse_COMMA[6] = {1,1,0,0,1,1};
  const boolean _morse_QUESTION[6] = {0,0,1,1,0,0};

  int _speakerPin = 0;
  int _ledPin = 0;
  int _unitTime = 60;

  int _tone = NOTE_E5;

  int _dit = 0;
  int _da = 0;
  int _letterBreak = 0;
  int _wordBreak = 0;

};

#endif 